/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public abstract class BaseJoinStrategy
implements JoinStrategy {
    public boolean bulkFetchOK() {
        return true;
    }

    public boolean ignoreBulkFetch() {
        return false;
    }

    protected void fillInScanArgs1(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder2) throws StandardException {
        boolean bl = optimizablePredicateList.sameStartStopPosition();
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        long l = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getConglomerateNumber();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = transactionController.getStaticCompiledConglomInfo(l);
        methodBuilder.push(l);
        methodBuilder.push(expressionClassBuilder.addItem(staticCompiledOpenConglomInfo));
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        methodBuilder.push(optimizable.getResultSetNumber());
        optimizablePredicateList.generateStartKey(expressionClassBuilder, methodBuilder, optimizable);
        methodBuilder.push(optimizablePredicateList.startOperator(optimizable));
        if (!bl) {
            optimizablePredicateList.generateStopKey(expressionClassBuilder, methodBuilder, optimizable);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        methodBuilder.push(optimizablePredicateList.stopOperator(optimizable));
        methodBuilder.push(bl);
        optimizablePredicateList.generateQualifiers(expressionClassBuilder, methodBuilder, optimizable, true);
        methodBuilder.upCast("org.apache.derby.iapi.store.access.Qualifier[][]");
    }

    protected void fillInScanArgs2(MethodBuilder methodBuilder, Optimizable optimizable, int n, int n2, int n3, int n4, boolean bl, int n5) throws StandardException {
        methodBuilder.push(optimizable.getBaseTableName());
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (conglomerateDescriptor.isConstraint()) {
            DataDictionary dataDictionary = optimizable.getDataDictionary();
            TableDescriptor tableDescriptor = optimizable.getTableDescriptor();
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
            methodBuilder.push(constraintDescriptor.getConstraintName());
        } else if (conglomerateDescriptor.isIndex()) {
            methodBuilder.push(conglomerateDescriptor.getConglomerateName());
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        methodBuilder.push(conglomerateDescriptor.isConstraint());
        methodBuilder.push(optimizable.forUpdate());
        methodBuilder.push(n2);
        methodBuilder.push(n3);
        methodBuilder.push(n4);
        methodBuilder.push(bl);
        methodBuilder.push(n5);
        if (n > 0) {
            methodBuilder.push(n);
        }
        if (this.validForOutermostTable()) {
            methodBuilder.push(optimizable.isOneRowScan());
        }
        methodBuilder.push(optimizable.getTrulyTheBestAccessPath().getCostEstimate().rowCount());
        methodBuilder.push(optimizable.getTrulyTheBestAccessPath().getCostEstimate().getEstimatedCost());
    }

    public boolean isHashJoin() {
        return false;
    }

    protected boolean validForOutermostTable() {
        return false;
    }

    public abstract boolean feasible(Optimizable var1, OptimizablePredicateList var2, Optimizer var3) throws StandardException;

    public abstract boolean multiplyBaseCostByOuterRows();

    public abstract OptimizablePredicateList getBasePredicates(OptimizablePredicateList var1, OptimizablePredicateList var2, Optimizable var3) throws StandardException;

    public abstract double nonBasePredicateSelectivity(Optimizable var1, OptimizablePredicateList var2);

    public abstract void putBasePredicates(OptimizablePredicateList var1, OptimizablePredicateList var2) throws StandardException;

    public abstract void estimateCost(Optimizable var1, OptimizablePredicateList var2, ConglomerateDescriptor var3, CostEstimate var4, Optimizer var5, CostEstimate var6) throws StandardException;

    public abstract double memoryUsage(double var1, double var3);

    public abstract String getName();

    public abstract int scanCostType();

    public abstract String resultSetMethodName(boolean var1);

    public abstract String joinResultSetMethodName();

    public abstract String halfOuterJoinResultSetMethodName();

    public abstract int getScanArgs(TransactionController var1, MethodBuilder var2, Optimizable var3, OptimizablePredicateList var4, OptimizablePredicateList var5, ExpressionClassBuilderInterface var6, int var7, MethodBuilder var8, int var9, int var10, int var11, boolean var12, int var13) throws StandardException;

    public abstract void divideUpPredicateLists(Optimizable var1, OptimizablePredicateList var2, OptimizablePredicateList var3, OptimizablePredicateList var4, OptimizablePredicateList var5, DataDictionary var6) throws StandardException;

    public abstract boolean doesMaterialization();
}

